//
//  table__h_e_a_d.h
//  GSFontTools
//
//  Created by Georg Seifert on 28.07.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GSFontTools/TTable.h>

typedef enum : uint16 {
	OTHEADFlagBaselineAty = 1,
	OTHEADFlagLeftSidebearingPoint = 1 << 1,
	OTHEADFlagInstructionsDependOnPointSize = 1 << 2,
	OTHEADFlagForcePpemToInteger = 1 << 3,
	OTHEADFlagInstructionsAlterAdvanceWidth = 1 << 4,
	OTHEADFlagFontDataIsLossless = 1 << 11,
	OTHEADFlagFontConverted = 1 << 12,
	OTHEADFlagFontOptimizedForClearType = 1 << 13,
	OTHEADFlagLastResortFont = 1 << 14,
} OTHEADFlags;

@interface table__h_e_a_d : TTable {
	uint16_t _majorVersion;
	uint16_t _minorVersion;
	Fixed _fontRevision;			// 16.16F
	NSUInteger _checkSumAdjustment;	// I
	NSUInteger _magicNumber;		// I
	OTHEADFlags _flags;				// H
	unsigned short _unitsPerEm;		// H
	NSDate *_created;				// 8s
	NSDate *_modified;				// 8s
	NSRect _bounds;
	// xMin;						// h
	// yMin;						// h
	// xMax;						// h
	// yMax;						// h
	unsigned short _macStyle;		// H
	unsigned short _lowestRecPPEM;	// H
	short _fontDirectionHint;		// h
	BOOL _indexToLocFormat;			// h
	short _glyphDataFormat;			// h
}

@property (nonatomic, assign) uint16_t majorVersion;
@property (nonatomic, assign) uint16_t minorVersion;
@property (nonatomic, assign) Fixed fontRevision;
@property (nonatomic, assign) NSUInteger checkSumAdjustment;
@property (nonatomic, assign) NSUInteger magicNumber;
@property (nonatomic, assign) OTHEADFlags flags;
@property (nonatomic, assign) unsigned short unitsPerEm;
@property (nonatomic, retain) NSDate *created;
@property (nonatomic, retain) NSDate *modified;
@property (nonatomic, assign) NSRect bounds;
@property (nonatomic, assign) unsigned short macStyle;
@property (nonatomic, assign) unsigned short lowestRecPPEM;
@property (nonatomic, assign) short fontDirectionHint;
@property (nonatomic, assign) BOOL indexToLocFormat;
@property (nonatomic, assign) short glyphDataFormat;
@end
